/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.geometry;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Size;

public final class Region {
    private final Position position;
    private final Size size;

    public Region(Position position2, Size size2) {
        if (position2 == null) {
            throw new NullPointerException("Position cannot be null.");
        }
        if (size2 == null) {
            throw new NullPointerException("Size cannot be null.");
        }
        this.position = position2;
        this.size = size2;
    }

    public Position getPosition() {
        return this.position;
    }

    public Size getSize() {
        return this.size;
    }

    public Rectangle calculate(int n, int n2) {
        Dimension dimension = this.size.calculate(n, n2);
        Point point = this.position.calculate(n, n2, dimension.width, dimension.height, 0, 0, 0, 0);
        Rectangle rectangle = new Rectangle(0, 0, n, n2);
        Rectangle rectangle2 = new Rectangle(point, dimension);
        return rectangle.intersection(rectangle2);
    }

    public String toString() {
        return "Region [position=" + this.position + ", size=" + this.size + "]";
    }
}

